/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;
import net.nooj4nlp.controller.SyntacticTreeShell.SyntacticTreeShellController;
import net.nooj4nlp.gui.components.STree;

public class JSTree
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SyntacticTreeShellController controller;

    @Override
    public void paint(Graphics grphcs) {
        super.paint(grphcs);
        if (this.controller.getTree() == null) {
            grphcs.dispose();
            return;
        }
        HashMap<String, ArrayList<Integer>> bridges = new HashMap<String, ArrayList<Integer>>();
        this.controller.getTree().draw(grphcs, this.controller.getShell().getCbDisplayAll().isSelected(), bridges);
        if (bridges.size() > 0) {
            int nb = 1;
            Iterator<String> iterator = bridges.keySet().iterator();
            while (iterator.hasNext()) {
                String o;
                String xref = o = iterator.next();
                ArrayList<Integer> b = bridges.get(xref);
                int xlast = b.get(0);
                for (int i = 1; i < b.size(); ++i) {
                    int xcurrent = b.get(i);
                    this.drawBridge(grphcs, Color.BLUE, xlast, xcurrent, nb);
                    xlast = xcurrent;
                }
                ++nb;
            }
        }
        grphcs.dispose();
    }

    private void drawBridge(Graphics g, Color color, int xsource, int xdest, int nb) {
        int y = this.controller.getShell().getPanel1().getHeight() - 2 * STree.LINE;
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke());
        graphics.drawLine(xsource, y + 10 * nb, xdest, y + 10 * nb);
        graphics.drawLine(xsource, y + 10 * nb, xsource, y);
        graphics.drawLine(xdest, y + 10 * nb, xdest, y);
    }

    public void setController(SyntacticTreeShellController controller) {
        this.controller = controller;
    }
}

